//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property description "DEMO Indicator"
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_applied_price   PRICE_CLOSE
#property indicator_buffers         2
#property indicator_plots           2
//+----------------+
#property indicator_type1           DRAW_LINE
#property indicator_color1          clrRed
#property indicator_style1          STYLE_SOLID
#property indicator_width1          2
//+----------------+
#property indicator_type2           DRAW_LINE
#property indicator_color2          clrBlue
#property indicator_style2          STYLE_SOLID
#property indicator_width2          2
//+------------------------------------------------------------------+
const struct stAverange
{
    uint           nPeriods;
    ENUM_MA_METHOD Method;
}Averange[] =
{
    {9, MODE_EMA},
    {20, MODE_SMA}
};
//+----------------+
struct stInfos
{
    double   Buff_iMA[];
    int      Handle;
}Infos[Averange.Size()];
//+------------------------------------------------------------------+
int OnInit(void)
{
    for (uint c = 0; c < Averange.Size(); c++)
    {
        SetIndexBuffer(c, Infos[c].Buff_iMA, INDICATOR_DATA);
        if ((Infos[c].Handle = iMA(NULL, NULL, Averange[c].nPeriods, 0, Averange[c].Method, _AppliedTo)) == INVALID_HANDLE)
        {
            Print("Could not start the indicator...");
            return INIT_FAILED;
        };
    }

    return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
    for (uint c = 0; c < Averange.Size(); c++)
    {
  	    ArrayInitialize(Infos[c].Buff_iMA, EMPTY_VALUE);
        CopyBuffer(Infos[c].Handle, 0, 0, Averange[c].nPeriods, Infos[c].Buff_iMA);
    }

    return rates_total;
};
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
    for (uint c = 0; c < Averange.Size(); c++)
        IndicatorRelease(Infos[c].Handle);
};
//+------------------------------------------------------------------+